/*
 * Decompiled with CFR 0.152.
 */
package kerg.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AuthProvider;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class Signatures {
    public static final String ALGORITHM_NAME = "SHA1withRSA";
    public static final String KEYS_ALGORITHM_NAME = "RSA";
    private static final String PKCS11_CARD_NAME = "eToken";
    private static final String PKCS11_PROVIDER = "SunPKCS11-eToken";
    private static String DLL_PKCS11_PKI = "eTPKCS11.dll";
    private static final Logger log = Logger.getLogger("Signatures");

    public static void main(String[] stringArray) {
        try {
            Signatures signatures = new Signatures();
            signatures.test9();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printServices(Set<Provider.Service> set) {
        Provider.Service[] serviceArray = set.toArray(new Provider.Service[set.size()]);
        Arrays.sort(serviceArray, 0, serviceArray.length, new Comparator<Provider.Service>(){

            @Override
            public int compare(Provider.Service service, Provider.Service service2) {
                return service.toString().compareTo(service2.toString());
            }
        });
        for (Provider.Service service : serviceArray) {
            System.err.println(service.getType() + "|" + service.getAlgorithm());
        }
    }

    public static void signFile(String string, PrivateKey privateKey, File file, File file2) throws IOException, GeneralSecurityException {
        if (file.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Input file is too long");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        Signature signature = Signature.getInstance(string);
        signature.initSign(privateKey, new SecureRandom());
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(byArray2);
        fileOutputStream.close();
    }

    public static byte[] signFile(String string, PrivateKey privateKey, File file) throws IOException, GeneralSecurityException {
        if (file.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Input file is too long");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        Signature signature = Signature.getInstance(string);
        signature.initSign(privateKey, new SecureRandom());
        signature.update(byArray);
        return signature.sign();
    }

    public static File signFile(String string, PrivateKey privateKey, File file, String string2) throws IOException, GeneralSecurityException {
        int n;
        byte[] byArray = Signatures.signFile(string, privateKey, file);
        File file2 = new File(file.getParent(), file.getName() + string2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        zipOutputStream.setLevel(1);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray2 = new byte[8192];
        zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
        while ((n = bufferedInputStream.read(byArray2, 0, byArray2.length)) != -1) {
            zipOutputStream.write(byArray2, 0, n);
        }
        bufferedInputStream.close();
        String string3 = file.getName() + ".signature";
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        zipOutputStream.write(byArray);
        zipOutputStream.flush();
        zipOutputStream.close();
        return file2;
    }

    public static File signFile(String string, PrivateKey privateKey, File file, String string2, String string3) throws IOException, GeneralSecurityException {
        int n;
        byte[] byArray = Signatures.signFile(string, privateKey, file);
        File file2 = new File(file.getParent(), file.getName() + string3);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        zipOutputStream.setLevel(1);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray2 = new byte[8192];
        zipOutputStream.putNextEntry(new ZipEntry(string2));
        while ((n = bufferedInputStream.read(byArray2, 0, byArray2.length)) != -1) {
            zipOutputStream.write(byArray2, 0, n);
        }
        bufferedInputStream.close();
        String string4 = string2 + ".signature";
        zipOutputStream.putNextEntry(new ZipEntry(string4));
        zipOutputStream.write(byArray);
        zipOutputStream.flush();
        zipOutputStream.close();
        return file2;
    }

    private static String getNameNoExt(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static boolean verifyFile(String string, PublicKey publicKey, File file, File file2) throws IOException, GeneralSecurityException {
        if (file.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Input file is too long");
        }
        if (file2.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Signature file is too long");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        FileInputStream fileInputStream2 = new FileInputStream(file2);
        byte[] byArray2 = new byte[(int)file2.length()];
        fileInputStream2.read(byArray2);
        fileInputStream2.close();
        Signature signature = Signature.getInstance(string);
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(byArray2);
    }

    public static boolean verifyFile(String string, PublicKey publicKey, File file) throws IOException, GeneralSecurityException {
        Object object;
        if (file.length() > Integer.MAX_VALUE) {
            throw new RuntimeException("Input file is too long");
        }
        byte[] byArray = new byte[8192];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null) {
            int n;
            object = new ByteArrayOutputStream();
            do {
                if ((n = zipInputStream.read(byArray)) <= 0) continue;
                ((ByteArrayOutputStream)object).write(byArray, 0, n);
            } while (n != -1);
            byArray2 = ((ByteArrayOutputStream)object).toByteArray();
            ((ByteArrayOutputStream)object).close();
        }
        if ((object = zipInputStream.getNextEntry()) != null) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            do {
                if ((n = zipInputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n != -1);
            byArray3 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
        Signature signature = Signature.getInstance(string);
        signature.initVerify(publicKey);
        if (byArray2 != null) {
            signature.update(byArray2);
        }
        return signature.verify(byArray3);
    }

    private void test1() throws GeneralSecurityException, IOException {
        File file = new File("D:/SI/7-32/iNet.devel/run/hardmask.pdf");
        File file2 = new File("D:/SI/7-32/iNet.devel/run/hardmask.sig");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEYS_ALGORITHM_NAME);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Signatures.signFile(ALGORITHM_NAME, keyPair.getPrivate(), file, file2);
        if (Signatures.verifyFile(ALGORITHM_NAME, keyPair.getPublic(), file, file2)) {
            System.err.println("OK");
        } else {
            System.err.println("Fail");
        }
    }

    public static void test8() {
        try {
            Signatures.createKeys("D:/SI/7-32/iNet.devel", "klucz");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void test9() throws Exception {
        PublicKey publicKey = (PublicKey)Signatures.loadKey(new File("klucz.public.key"), true, KEYS_ALGORITHM_NAME);
        boolean bl = Signatures.verifyFile(ALGORITHM_NAME, publicKey, new File("build.xml"), new File("$$$.sig"));
        System.err.print("R: " + bl);
    }

    public static void createKeys(String string, String string2) throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEYS_ALGORITHM_NAME);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Signatures.saveKeyPair(string, string2, keyPair);
    }

    public static void saveKeyPair(String string, String string2, KeyPair keyPair) throws IOException {
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        File file = new File(string, string2 + ".public.key");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(x509EncodedKeySpec.getEncoded());
        fileOutputStream.close();
        File file2 = new File(string, string2 + ".private.key");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(pKCS8EncodedKeySpec.getEncoded());
        fileOutputStream.close();
    }

    public static Key loadKey(File file, boolean bl, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        Key key;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        if (bl) {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            key = keyFactory.generatePublic(x509EncodedKeySpec);
        } else {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            key = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        return key;
    }

    public KeyPair loadKeyPair(String string, String string2, String string3) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File file = new File(string, string2 + ".private.key");
        PrivateKey privateKey = (PrivateKey)Signatures.loadKey(file, false, string3);
        File file2 = new File(string, string2 + ".private.key");
        PublicKey publicKey = (PublicKey)Signatures.loadKey(file2, true, string3);
        return new KeyPair(publicKey, privateKey);
    }

    public void test2() {
        String string = "C:/Windows/System32/" + DLL_PKCS11_PKI;
        AuthProvider authProvider = this.addETokenProvider(PKCS11_CARD_NAME, string, 2);
        try {
            authProvider.login(null, new CP());
            Set<Provider.Service> set = authProvider.getServices();
            for (Provider.Service service : set) {
                System.err.println(service.toString());
            }
            authProvider.logout();
        }
        catch (LoginException loginException) {
            loginException.printStackTrace();
        }
        Security.removeProvider(authProvider.getName());
    }

    private void test3() throws GeneralSecurityException, IOException {
        File file = new File("D:/SI/7-32/iNet.devel/run/hardmask.pdf");
        File file2 = new File("D:/SI/7-32/iNet.devel/run/hardmask.sig");
        String string = "C:/Windows/System32/" + DLL_PKCS11_PKI;
        AuthProvider authProvider = this.addETokenProvider(PKCS11_CARD_NAME, string, 2);
        KeyStore keyStore = KeyStore.getInstance("PKCS11", authProvider);
        keyStore.load(null, "1234567890".toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("TEST", null);
        Signatures.signFile(ALGORITHM_NAME, privateKey, file, file2);
        Certificate certificate = keyStore.getCertificate("TEST");
        if (Signatures.verifyFile(ALGORITHM_NAME, certificate.getPublicKey(), file, file2)) {
            System.err.println("OK");
        } else {
            System.err.println("Fail");
        }
        Security.removeProvider(authProvider.getName());
    }

    private void test5() throws GeneralSecurityException, IOException {
        String string = "C:/Windows/System32/" + DLL_PKCS11_PKI;
        AuthProvider authProvider = this.addETokenProvider(PKCS11_CARD_NAME, string, 2);
        Signatures.printServices(authProvider.getServices());
        Security.removeProvider(authProvider.getName());
    }

    protected AuthProvider addETokenProvider(String string, String string2, int n) {
        AuthProvider authProvider = null;
        String string3 = this.getProviderConfigContents(string, string2, n);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.security.pkcs11.SunPKCS11");
            if (clazz != null) {
                Constructor<?> constructor = clazz.getConstructor(InputStream.class);
                try {
                    authProvider = (AuthProvider)constructor.newInstance(byteArrayInputStream);
                }
                catch (Exception exception) {
                    log.log(Level.CONFIG, "B\u0142\u0105d tworzenia obiektu 'AuthProvider'", exception);
                }
            }
            if (authProvider != null) {
                Security.addProvider(authProvider);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return authProvider;
    }

    private String getProviderConfigContents(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name=");
        stringBuilder.append(string);
        stringBuilder.append('\n');
        stringBuilder.append("library=");
        stringBuilder.append(string2);
        stringBuilder.append('\n');
        if (n > -1) {
            stringBuilder.append("slot=");
            stringBuilder.append(n);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static class CP
    implements CallbackHandler {
        private CP() {
        }

        @Override
        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            PasswordCallback passwordCallback = (PasswordCallback)callbackArray[0];
            passwordCallback.setPassword("1234567890".toCharArray());
        }
    }
}

