/*
 * Decompiled with CFR 0.152.
 */
package kerg.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import kerg.utils.Signatures;

public class SignaturesDialog
extends JDialog {
    private static final long serialVersionUID = 436671974441266328L;
    private static File currentDirectory = new File(".");
    private static int WIDTH = 600;
    private static int HEIGHT = 250;
    private JTabbedPane tabbedPane = null;
    private JPanel signPanel = null;
    private JPanel verifyPanel = null;
    private JTextField fileSignTextField = null;
    private JTextField keySignTextField = null;
    private JButton browseFileSignButton = null;
    private JButton browseKeySignButton = null;
    private JPanel buttonsSignPanel = null;
    private JButton signButton = null;
    private JTextField signResultTextField = null;
    private File selectedFile4Sign = null;
    private File selectedKey4Sign = null;
    private JTextField fileVerifyTextField = null;
    private JTextField keyVerifyTextField = null;
    private JTextField signatureVerifyTextField = null;
    private JButton browseFileVerifyButton = null;
    private JButton browseSignatureVerifyButton = null;
    private JButton browseKeyVerifyButton = null;
    private JPanel buttonsVerifyPanel = null;
    private JButton verifyButton = null;
    private JTextField verifyResultTextField = null;
    private File selectedFile4Verify = null;
    private File selectedSignature4Verify = null;
    private File selectedKey4Verify = null;

    public SignaturesDialog() {
        super((Frame)null, "Geo-Info 7: Podpisy Cyfrowe", true);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(WIDTH, HEIGHT));
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - WIDTH) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - HEIGHT) / 2;
        this.setLocation(n, n2);
        this.add(this.getTabbedPane());
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Podpisywanie Dokumentu", this.getSignPanel());
            this.tabbedPane.addTab("Weryfikacja Podpisu", this.getVerifyPanel());
        }
        return this.tabbedPane;
    }

    private JPanel getSignPanel() {
        if (this.signPanel == null) {
            this.signPanel = new JPanel();
            this.signPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            JLabel jLabel = new JLabel("Dokument do podpisania");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(5, 5, 0, 5);
            JLabel jLabel2 = new JLabel("Klucz prywatny osoby sk\u0142adaj\u0105cej podpis");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            this.signPanel.add((Component)jLabel, gridBagConstraints);
            this.signPanel.add((Component)this.getFileSignTextField(), gridBagConstraints2);
            this.signPanel.add((Component)this.getBrowseFileSignButton(), gridBagConstraints3);
            this.signPanel.add((Component)jLabel2, gridBagConstraints4);
            this.signPanel.add((Component)this.getKeySignTextField(), gridBagConstraints5);
            this.signPanel.add((Component)this.getBrowseKeySignButton(), gridBagConstraints6);
            this.signPanel.add((Component)this.getButtonsSignPanel(), gridBagConstraints7);
            this.signPanel.add((Component)this.getSignResultTextField(), gridBagConstraints8);
        }
        return this.signPanel;
    }

    private JTextField getSignResultTextField() {
        if (this.signResultTextField == null) {
            this.signResultTextField = new JTextField();
            this.signResultTextField.setEditable(false);
            this.signResultTextField.setBorder(null);
        }
        return this.signResultTextField;
    }

    private JTextField getFileSignTextField() {
        if (this.fileSignTextField == null) {
            this.fileSignTextField = new JTextField();
            this.fileSignTextField.setEditable(false);
        }
        return this.fileSignTextField;
    }

    private JButton getBrowseFileSignButton() {
        if (this.browseFileSignButton == null) {
            this.browseFileSignButton = new JButton();
            this.browseFileSignButton.setText("...");
            int n = this.browseFileSignButton.getPreferredSize().height;
            this.browseFileSignButton.setPreferredSize(new Dimension(n, n));
            this.browseFileSignButton.setMinimumSize(new Dimension(n, n));
            this.browseFileSignButton.setMaximumSize(new Dimension(n, n));
            this.browseFileSignButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.browseSignFile();
                }
            });
        }
        return this.browseFileSignButton;
    }

    private JTextField getKeySignTextField() {
        if (this.keySignTextField == null) {
            this.keySignTextField = new JTextField();
            this.keySignTextField.setEditable(false);
        }
        return this.keySignTextField;
    }

    private JButton getBrowseKeySignButton() {
        if (this.browseKeySignButton == null) {
            this.browseKeySignButton = new JButton();
            this.browseKeySignButton.setText("...");
            int n = this.browseKeySignButton.getPreferredSize().height;
            this.browseKeySignButton.setPreferredSize(new Dimension(n, n));
            this.browseKeySignButton.setMinimumSize(new Dimension(n, n));
            this.browseKeySignButton.setMaximumSize(new Dimension(n, n));
            this.browseKeySignButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.browseSignKey();
                }
            });
        }
        return this.browseKeySignButton;
    }

    private JPanel getButtonsSignPanel() {
        if (this.buttonsSignPanel == null) {
            this.buttonsSignPanel = new JPanel();
            this.buttonsSignPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            this.buttonsSignPanel.add((Component)Box.createHorizontalBox(), gridBagConstraints);
            this.buttonsSignPanel.add((Component)this.getSignButton(), gridBagConstraints2);
        }
        return this.buttonsSignPanel;
    }

    private JButton getSignButton() {
        if (this.signButton == null) {
            this.signButton = new JButton();
            this.signButton.setText("Podpisz dokument");
            this.signButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.sign();
                }
            });
        }
        return this.signButton;
    }

    private JPanel getVerifyPanel() {
        if (this.verifyPanel == null) {
            this.verifyPanel = new JPanel();
            this.verifyPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            JLabel jLabel = new JLabel("Dokument do weryfikacji");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(5, 5, 0, 5);
            JLabel jLabel2 = new JLabel("Podpis cyfrowy dokumentu");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(5, 5, 0, 5);
            JLabel jLabel3 = new JLabel("Klucz publiczny osoby dostarczaj\u0105cej dokument");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(0, 5, 5, 0);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 5;
            gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 6;
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 7;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            this.verifyPanel.add((Component)jLabel, gridBagConstraints);
            this.verifyPanel.add((Component)this.getFileVerifyTextField(), gridBagConstraints2);
            this.verifyPanel.add((Component)this.getBrowseFileVerifyButton(), gridBagConstraints3);
            this.verifyPanel.add((Component)jLabel2, gridBagConstraints4);
            this.verifyPanel.add((Component)this.getSignatureVerifyTextField(), gridBagConstraints5);
            this.verifyPanel.add((Component)this.getBrowseSignatureVerifyButton(), gridBagConstraints6);
            this.verifyPanel.add((Component)jLabel3, gridBagConstraints7);
            this.verifyPanel.add((Component)this.getKeyVerifyTextField(), gridBagConstraints8);
            this.verifyPanel.add((Component)this.getBrowseKeyVerifyButton(), gridBagConstraints9);
            this.verifyPanel.add((Component)this.getButtonsVerifyPanel(), gridBagConstraints10);
            this.verifyPanel.add((Component)this.getVerifyResultTextField(), gridBagConstraints11);
        }
        return this.verifyPanel;
    }

    private JTextField getVerifyResultTextField() {
        if (this.verifyResultTextField == null) {
            this.verifyResultTextField = new JTextField();
            this.verifyResultTextField.setEditable(false);
            this.verifyResultTextField.setBorder(null);
        }
        return this.verifyResultTextField;
    }

    private JTextField getFileVerifyTextField() {
        if (this.fileVerifyTextField == null) {
            this.fileVerifyTextField = new JTextField();
            this.fileVerifyTextField.setEditable(false);
        }
        return this.fileVerifyTextField;
    }

    private JButton getBrowseFileVerifyButton() {
        if (this.browseFileVerifyButton == null) {
            this.browseFileVerifyButton = new JButton();
            this.browseFileVerifyButton.setText("...");
            int n = this.browseFileVerifyButton.getPreferredSize().height;
            this.browseFileVerifyButton.setPreferredSize(new Dimension(n, n));
            this.browseFileVerifyButton.setMinimumSize(new Dimension(n, n));
            this.browseFileVerifyButton.setMaximumSize(new Dimension(n, n));
            this.browseFileVerifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.browseVerifyFile();
                }
            });
        }
        return this.browseFileVerifyButton;
    }

    private JTextField getKeyVerifyTextField() {
        if (this.keyVerifyTextField == null) {
            this.keyVerifyTextField = new JTextField();
            this.keyVerifyTextField.setEditable(false);
        }
        return this.keyVerifyTextField;
    }

    private JTextField getSignatureVerifyTextField() {
        if (this.signatureVerifyTextField == null) {
            this.signatureVerifyTextField = new JTextField();
            this.signatureVerifyTextField.setEditable(false);
        }
        return this.signatureVerifyTextField;
    }

    private JButton getBrowseSignatureVerifyButton() {
        if (this.browseSignatureVerifyButton == null) {
            this.browseSignatureVerifyButton = new JButton();
            this.browseSignatureVerifyButton.setText("...");
            int n = this.browseSignatureVerifyButton.getPreferredSize().height;
            this.browseSignatureVerifyButton.setPreferredSize(new Dimension(n, n));
            this.browseSignatureVerifyButton.setMinimumSize(new Dimension(n, n));
            this.browseSignatureVerifyButton.setMaximumSize(new Dimension(n, n));
            this.browseSignatureVerifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.browseVerifySignature();
                }
            });
        }
        return this.browseSignatureVerifyButton;
    }

    private JButton getBrowseKeyVerifyButton() {
        if (this.browseKeyVerifyButton == null) {
            this.browseKeyVerifyButton = new JButton();
            this.browseKeyVerifyButton.setText("...");
            int n = this.browseKeyVerifyButton.getPreferredSize().height;
            this.browseKeyVerifyButton.setPreferredSize(new Dimension(n, n));
            this.browseKeyVerifyButton.setMinimumSize(new Dimension(n, n));
            this.browseKeyVerifyButton.setMaximumSize(new Dimension(n, n));
            this.browseKeyVerifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.browseVerifyKey();
                }
            });
        }
        return this.browseKeyVerifyButton;
    }

    private JPanel getButtonsVerifyPanel() {
        if (this.buttonsVerifyPanel == null) {
            this.buttonsVerifyPanel = new JPanel();
            this.buttonsVerifyPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            this.buttonsVerifyPanel.add((Component)Box.createHorizontalBox(), gridBagConstraints);
            this.buttonsVerifyPanel.add((Component)this.getVerifyButton(), gridBagConstraints2);
        }
        return this.buttonsVerifyPanel;
    }

    private JButton getVerifyButton() {
        if (this.verifyButton == null) {
            this.verifyButton = new JButton();
            this.verifyButton.setText("Zweryfikuj dokument");
            this.verifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SignaturesDialog.this.verify();
                }
            });
        }
        return this.verifyButton;
    }

    protected void browseSignKey() {
        this.selectedKey4Sign = this.browseFile("Podpisz dokument", this.selectedKey4Sign, this.keySignTextField);
    }

    protected void browseSignFile() {
        this.selectedFile4Sign = this.browseFile("Podpisz dokument", this.selectedFile4Sign, this.fileSignTextField);
    }

    protected void browseVerifySignature() {
        this.selectedSignature4Verify = this.browseFile("Zweryfikuj dokument", this.selectedSignature4Verify, this.signatureVerifyTextField);
    }

    protected void browseVerifyKey() {
        this.selectedKey4Verify = this.browseFile("Zweryfikuj dokument", this.selectedKey4Verify, this.keyVerifyTextField);
    }

    protected void browseVerifyFile() {
        this.selectedFile4Verify = this.browseFile("Zweryfikuj dokument", this.selectedFile4Verify, this.fileVerifyTextField);
    }

    private File browseFile(String string, File file, JTextField jTextField) {
        File file2 = file;
        JFileChooser jFileChooser = new JFileChooser(currentDirectory);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setApproveButtonText("Wybierz plik");
        jFileChooser.setName(string);
        int n = jFileChooser.showOpenDialog(this);
        currentDirectory = jFileChooser.getCurrentDirectory();
        if (n == 0) {
            file2 = jFileChooser.getSelectedFile();
            jTextField.setText(file2.getAbsolutePath());
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sign() {
        File file = null;
        try {
            PrivateKey privateKey = (PrivateKey)Signatures.loadKey(this.selectedKey4Sign, false, "RSA");
            file = Signatures.signFile("SHA1withRSA", privateKey, this.selectedFile4Sign, ".zip");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (file != null) {
                this.signResultTextField.setForeground(Color.GREEN.darker().darker());
                this.signResultTextField.setText("Podpisany plik wynikowy: '" + file.getAbsolutePath() + "'.");
            } else {
                this.signResultTextField.setForeground(Color.RED);
                this.signResultTextField.setText("Wyst\u0105pi\u0142 problem podczas podpisywania dokumentu.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verify() {
        boolean bl = false;
        try {
            PublicKey publicKey = (PublicKey)Signatures.loadKey(this.selectedKey4Verify, true, "RSA");
            bl = Signatures.verifyFile("SHA1withRSA", publicKey, this.selectedFile4Verify, this.selectedSignature4Verify);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bl) {
                this.verifyResultTextField.setForeground(Color.GREEN.darker().darker());
                this.verifyResultTextField.setText("Dokument zosta\u0142 zweryfikowany - jest autentyczny.");
            } else {
                this.verifyResultTextField.setForeground(Color.RED);
                this.verifyResultTextField.setText("Wyst\u0105pi\u0142 problem podczas weryfikacji dokumentu.");
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            exception.printStackTrace();
        }
        SignaturesDialog signaturesDialog = new SignaturesDialog();
        signaturesDialog.pack();
        signaturesDialog.setVisible(true);
    }
}

